unit uMain;

{

  AlphaCode Crypter
  Quellcode
  (c) 2003 - 2004 by David "mirage228" Fekete
  Alle Rechte vorbehalten.

  WWW:  http://www.mirage228.net
  Mail: administrator@mirage228.net

  Zuletzt compiliert in: Borland Delphi 6 Personal

  Lizenz:
  a)    Die Verwendung des Sourcecodes oder Teilen davon in anderen Anwendungen
        erfordert eine schriftliche Genehmigung des Autors.
  b)    Der Code wird "so, wie er ist" zur Vefgung gestellt.
        Ohne Gewhrleistung auf Funktionalitt etc.
        Der Autor haftet nicht fr Schden, die durch die Verwendung entstehen.
  c)    Alle Programme, die Teile dieses Codes als Basis haben, mssen diesen
        einen Verweis auf diese Quellcode in ihrer Dokumentation (Readme haben).
  d)    Es gilt zustzlich die Lizenzvereinbarung von AlphaCode Crypter
  e)    Sollten Bestimmungen dieses Vertrages ganz oder teilweise nicht rechtswirksam und/oder nicht
        durchfhrbar sein und/oder ihre Rechtswirksamkeit und/oder Durchfhrbarkeit spter verlieren,
        soll hierdurch die Gltigkeit der brigen Bestimmungen des Vertrages nicht berhrt werden.
        Das Gleiche gilt, soweit sich herausstellen sollte, dass der Vertrag eine Regelungslcke enthlt.
        Anstelle der unwirksamen und/oder undurchfhrbaren Bestimmungen oder zur Ausfllung der Lcke
        soll eine angemessene Regelung gelten, die, soweit rechtlich mglich, der beabsichtigten
        Regelung am nchsten kommt.
  f)    Falls Sie den Bedingungen nicht zustimmen, sind nicht berechtigt diesen Quellcode bzw.
        AlphaCode Crypter zu verwenden.


  Bentigte Packages fr die Compilierung:

  1.    TwoFish VCL Component von http://www.crypto-central.com/index.html
  2.    SHA VCL Component von http://www.crypto-central.com/index.html
  3.    TThemeManager (WindowsXP Theme Manager) fr Delphi von http://www.lischke-online.de 
}

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ThemeMgr, SHA, Twofish, ExtCtrls, ShellAPI;

type
  TCryptThread = class(TThread)
  private
    EnCrypt       : Boolean;
    OverwriteFiles: Boolean;
    Source, Target: String;
    InitVector,
    PassPhrase    : String;

  protected
    procedure Execute; override;

  public
    constructor Create(EnCrypt, OverwriteFiles: Boolean; const Source, Target,
      InitVector, PassPhrase: String);
end;

type
  TfrmMain = class(TForm)
    ThemeManager1: TThemeManager;
    lbCaption: TLabel;
    gbSource: TGroupBox;
    gbTarget: TGroupBox;
    edSource: TEdit;
    btnBrowseSource: TButton;
    btnBrowseTarget: TButton;
    edTarget: TEdit;
    gbSettings: TGroupBox;
    rbEnCrypt: TRadioButton;
    rbDeCrypt: TRadioButton;
    cbOverwriteTarget: TCheckBox;
    gbPassword: TGroupBox;
    lbEnterPassword: TLabel;
    edPassword1: TEdit;
    lbRepeatPassword: TLabel;
    edPassword2: TEdit;
    btnStart: TButton;
    btnQuit: TButton;
    btnAbout: TButton;
    lbCopyright: TLabel;
    Twofish: TTwofish;
    SHA: TSHA;
    OpenDialog: TOpenDialog;
    cbSearchNewFileName: TCheckBox;
    cbUseHashes: TCheckBox;
    pnCihperSelection: TPanel;
    rbCBCCipher: TRadioButton;
    rbECBCipher: TRadioButton;
    procedure btnQuitClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure rbEnCryptClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnBrowseSourceClick(Sender: TObject);
    procedure btnBrowseTargetClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    procedure WMDropFiles(var Msg: TWMDropFiles); message WM_DROPFILES;
    procedure SetComponentState(aState: Boolean);
    { Private declarations }
  public
    function Hash(const Str: String): String;
    procedure ThreadDone(Sender: TObject);
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  CryptThread: TCryptThread;

implementation

{$R *.dfm}

resourcestring
  COPYRIGHT = 'AlphaCode Crypter '+#169+' 2003 - 2004 David "mirage228" Fekete. Alle Rechte vorbehalten.' + #13#13 +
    'AlphaCode Crypter ist ein Mitglied der AlphaCode-Produktfamilie.'+ #13#10#13#10 +
    'Verwendet TwoFish Verschlsselungstechnologie von Bruce Schneier mit einer Komponente von TSM Inc.'+#13#10+
    'Produkt entwickelt in Borland Delphi 6 Personal' + #13#10 +
    'E-Mail: administrator@mirage228.net' + #13#10+
    'Homepage: http://www.mirage228.net';

//////////////////////////
//////////////////////////
// Thread fr
// Ver- und Entschlsseln
//////////////////////////
//////////////////////////

// Constructor fr den Encryption-Thread
constructor TCryptThread.Create(EnCrypt, OverwriteFiles: Boolean; const Source,
  Target, InitVector, PassPhrase: String);
begin
  Self.EnCrypt := EnCrypt;
  Self.OverwriteFiles := OverwriteFiles;
  Self.Source := Source;
  Self.Target := Target;
  Self.InitVector := InitVector;
  Self.PassPhrase := PassPhrase;
  FreeOnTerminate := True;
  inherited Create(False);
end;

// Hier wird der Ver- bzw. Entschlsselungsvorgang ausgefhrt
procedure TCryptThread.Execute;
var
  bUseTempFile: boolean; // Falls Quelldatei und Zieldatei gleich sind, temporre Datei verwenden!
  F1,
  F2: String;            // Dateinamen ("File1", "File2")
begin
  try
    F1 := Source;
    F2 := Target;

    bUseTempFile := False;
    if (FileExists(Target)) and (not OverwriteFiles) then
    begin
      // berschreiben besttigen lassen, falls Option nicht aktiviert.
      if Application.MessageBox(PCHAR(Format('Die Datei %s existiert bereits. '+
        'berschreiben?', [Target])),'Besttigen', MB_ICONQUESTION or
        MB_YESNO) = IDNO then
        Exit;
    end;

    // IVString und PassPhrase setzen
    frmMain.Twofish.LoadIVString(InitVector);
    frmMain.TwoFish.InitialiseString(PassPhrase);

    // Falls Quelldatei und Zieldatei gleich sind, temporre Datei verwenden!
    if AnsiCompareFileName(Source, Target) = 0 then
    begin
      bUseTempFile := True;
      CopyFile(PChar(Source),
        PChar(IncludeTrailingBackslash(GetEnvironmentVariable('Temp')) +
        ExtractFileName(Source)), False);
      DeleteFile(Source);
      F1 := IncludeTrailingBackslash(GetEnvironmentVariable('Temp')) +
        ExtractFileName(Source);
    end;

    // EnCrypt = True --> Verschlsseln ||| EnCrypt = False --> Entschlsseln
    if EnCrypt then
      frmMain.TwoFish.EncFile(F1, F2) else
    frmMain.TwoFish.DecFile(F1, F2);

    // ggf. Temporre Datei lschen
    if bUseTempFile then
      DeleteFile(PChar(IncludeTrailingBackslash(GetEnvironmentVariable('Temp'))+
        ExtractFileName(Source)));

    // sensible Daten lschen
    frmMain.TwoFish.Burn;

    // Erfolgsmeldung ausgeben, falls Vorgang erfolgreich
    Application.MessageBox(PCHAR('Die Datei '+Target+' wurde erfolgreich ' +
      'verarbeitet!'), 'Information', MB_ICONINFORMATION or MB_OK);
  except
    // Fehlermeldung bei Fehler ausgeben.
    Application.MessageBox(PCHAR('Es ist ein Fehler aufgetreten. ' +
      'Der Vorgang konnte nicht vollstndig abgeschlossen werden.' +
      #13#10#13#10 + 'Details:'+ #13#10 + SysErrorMessage(GetLastError)),
      'Fehler', MB_ICONERROR or MB_OK);
  end;
end;

//////////////////////////
//////////////////////////
// Selbst definierte
// Methoden.
//////////////////////////
//////////////////////////

// Erstellt einen Hash der Zeichenkette.
// Verwendet SHA-1 (160bit)
function TfrmMain.Hash(const Str: String): String;
begin
  SHA.Init;
  SHA.HashString(Str);
  SHA.Finish;
  Result := SHA.GetHashString;

  // sensible Daten lschen
  SHA.Burn;
end;


// Behandelt auf dem Formular abgelegte (gedraggte) Dateien
procedure TfrmMain.WMDropFiles(var Msg: TWMDropFiles);
var
  CFileName: array[0..MAX_PATH] of Char;
begin
  try
    if DragQueryFile(Msg.Drop, 0, CFileName, MAX_PATH) > 0 then
    begin
      edSource.Text := CFileName;
      Msg.Result := 0;
    end;
  finally
    DragFinish(Msg.Drop);
  end;
end;

// Setzt den Status der Komponent auf aState
procedure TfrmMain.SetComponentState(aState: Boolean);
const
  CursorState: array[Boolean] of TCursor = (crHourGlass, crDefault);
begin
  Self.Enabled := aState;
  Self.Cursor := CursorState[aState];
  gbSource.Cursor := CursorState[aState];
  gbTarget.Cursor := CursorState[aState];
  gbSettings.Cursor := CursorState[aState];
  gbPassword.Cursor := CursorState[aState];
  btnQuit.Enabled := aState;
  btnAbout.Enabled := aState;
  edSource.Enabled := aState;
  edTarget.Enabled := aState;
  edPassword1.Enabled := aState;
  edPassword2.Enabled := aState;
  rbEnCrypt.Enabled := aState;
  rbDeCrypt.Enabled := aState;
  rbECBCipher.Checked := aState;
  rbCBCCipher.Checked := aState;
  cbOverwriteTarget.Enabled := aState;
  cbSearchNewFileName.Enabled := aState;
  btnBrowseSource.Enabled := aState;
  btnBrowseTarget.Enabled := aState;
  lbEnterPassword.Enabled := aState;
  lbRepeatPassword.Enabled := aState;
end;

// Aktiviert die Komponenten nach dem Ende des Vorganges wieder
procedure TfrmMain.ThreadDone(Sender: Tobject);
begin
  SetComponentState(true);
  edPassword1.Clear;
  edPassword2.Clear;
  edSource.Clear;
  edTarget.Clear;
  if rbEnCrypt.Checked then btnStart.Caption := rbEnCrypt.Caption else
    btnStart.Caption := rbDeCrypt.Caption;
end;

//////////////////////////////
//////////////////////////////
// Delphi VCL Event Handler
//////////////////////////////
//////////////////////////////

procedure TfrmMain.btnQuitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  Application.MessageBox(PCHAR(COPYRIGHT), 'ber AlphaCode Crypter...',
    MB_ICONINFORMATION or MB_OK);
end;

procedure TfrmMain.rbEnCryptClick(Sender: TObject);
begin
  btnStart.Caption := (Sender as TRadioButton).Caption;
end;

procedure TfrmMain.btnStartClick(Sender: TObject);
var
  IV, PassPhrase: String;
begin
  // Falls der Vorgang abbgeborchen wurde
  if btnStart.Caption = 'Abbrechen' then
  begin
    TerminateThread(CryptThread.Handle, 0);
    if Application.MessageBox('Der Vorgang wurde abgebrochen! Mchten Sie ' +
      'die unvollstndige Zieldatei lschen?', 'Warnung', MB_ICONWARNING or
      MB_YESNO) = IDYES then
      DeleteFile(edTarget.Text);
    ThreadDone(Sender);
    Exit;
  end;

  // Passwortfelder auf Gleichheit prfen
  if (edPassword1.Text <> edPassword2.Text) then
  begin
    Application.MessageBox('Die eingebenen Passwrter sind nicht gleich. ' +
      'Bitte geben Sie in beide Felder das gleiche Passwort ein!', 'Fehler',
      MB_ICONERROR or MB_OK);
    edPassword1.Text := '';
    edPassword2.Text := '';
    Exit;
  end;

  // Versuchen unsichere Passwrter
  if (edPassword1.Text = '') then
  begin
    if Application.MessageBox('Hinweis: Sie haben kein Passwort gesetzt. ' +
      'Falls Sie kein Passwort setzen, ist die Verschlsselung nicht sicher, ' +
      'weil die Sicherheit ihres Dokumentes von ihrem gewhlten Passwort ' +
      'abhngt.' + #13#10 + 'Mchten Sie wirklich kein Passwort setzen?',
      'Warnung', MB_ICONWARNING or MB_YESNO) = IDNO then
      Exit;
  end;

  // Dateifelder auf Gleichheit prfen
  if (edSource.Text = '') or (edTarget.Text = '') then
  begin
    Application.MessageBox('Sie haben mindestens eine ungltige Datei ' +
      'zum Verarbeiten angegeben. Bitte geben Sie einen gltigen ' +
      'Dateinamen ein.','Fehler', MB_ICONERROR or MB_OK);
    Exit;
  end;

  // Quelldatei auf Existenz prfen
  if not FileExists(edSource.Text) then
  begin
    Application.MessageBox('Die angegebene Quelldatei wurde nicht gefunden. ' +
      'Bitte geben Sie eine gltige Datei an.', 'Fehler', MB_ICONERROR or MB_OK);
    Exit;
  end;

  // Cipher Modus setzen
  // Alte Dokumente haben ECB!
  if rbECBCipher.Checked then
    TwoFish.CipherMode := ECB else
  TwoFish.CipherMode := CBC;

  // Falls kein Passwort angegeben wurde, Standard-Passwrter verwenden,
  // sonst eingegeben Passwrter verwenden bzw. vorher noch hashen mit SHA-1
  // da die Passwrter gleich sind, ist egal, ob man edPasswort1 oder
  // edPasswort2 schreibt!
  // ------------------------
  // !!! Es werden _unsichere_ Standardpasswrter verwendet, falls kein Text eingegeben
  // wurde !!!
  if edPassword1.Text = '' then
  begin
    IV := 'Init Vector';
    PassPhrase := 'Pass Phrase';
  end else
  begin
    if cbUseHashes.Checked then // falls Hashes verwendet werden sollen...
      IV := Hash(edPassword1.Text) else  // ..und falls nicht
    IV := edPassword1.Text;
    PassPhrase := IV;
  end;

  // Komponenten deaktivieren
  SetComponentState(false);
  btnStart.Cursor := crDefault;
  btnStart.Caption := 'Abbrechen';
  Self.Update;

  // Vorgang starten!
  CryptThread := TCryptThread.Create(rbEnCrypt.Checked,
    cbOverwriteTarget.Checked, edSource.Text, edTarget.Text, IV, PassPhrase);
  CryptThread.OnTerminate := ThreadDone;
end;

procedure TfrmMain.btnBrowseSourceClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    edSource.Text := OpenDialog.FileName;

    if (cbSearchNewFileName.Checked) and (not FileExists(ChangeFileExt(edSource.Text,'.acd'))) then
      edTarget.Text := ChangeFileExt(edSource.Text,'.acd') else
    if (cbSearchNewFileName.Checked) and (FileExists(ChangeFileExt(edSource.Text,'.acd'))) then
      edTarget.Text := edSource.Text;
  end;
end;

procedure TfrmMain.btnBrowseTargetClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    edTarget.Text := OpenDialog.FileName;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  with Application do
  begin
    HintHidePause := 6000;
    HintPause := 400;
  end;
  DragAcceptFiles(Handle, True);
end;

procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if btnStart.Caption = 'Abbrechen' then
  begin
    CanClose := False;
    btnStart.Click;
  end;
end;

end.
